<?php
/*--------------------------------------------------------------------
 Repository.php 2020-2-24
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Attributes\SellingUnitWeight\Database\Repository;

use Gambio\Shop\Attributes\SellingUnitWeight\Database\Repository\DTO\AttributeWeightDtoCollection;
use Gambio\Shop\Attributes\SellingUnitWeight\Database\Repository\Readers\ReaderInterface;
use Gambio\Shop\ProductModifiers\Modifiers\Collections\ModifierIdentifierCollectionInterface;

/**
 * Class Repository
 * @package Gambio\Shop\Attributes\SellingUnitWeight\Database\Repository
 */
class Repository implements RepositoryInterface
{
    /**
     * @var ReaderInterface
     */
    protected $reader;
    
    
    /**
     * Repository constructor.
     *
     * @param ReaderInterface $reader
     */
    public function __construct(ReaderInterface $reader)
    {
        $this->reader = $reader;
    }
    
    
    /**
     * @inheritDoc
     */
    public function attributeWeights(ModifierIdentifierCollectionInterface $modifiers): AttributeWeightDtoCollection
    {
        return $this->reader->attributeWeights($modifiers);
    }
}